#!/usr/local/bin/perl
# Show server or domain information

use strict;
use warnings;
no warnings 'redefine';
no warnings 'uninitialized';
require "gray-theme/gray-theme-lib.pl";
require "gray-theme/theme.pl";
&ReadParse();
&load_theme_library();
our ($current_theme, %gconfig, %in);
our %text = &load_language($current_theme);
my $bar_width = 500;

# Get system info to show
my $sects = get_right_frame_sections();
my @info = &list_combined_system_info($sects, \%in);

# Redirect if needed
my ($redir) = grep { $_->{'type'} eq 'redirect' } @info;
if ($redir) {
	&redirect($redir->{'url'});
	return;
	}

my $prehead = defined(&WebminCore::theme_prehead) ?
		&capture_function_output(\&WebminCore::theme_prehead) : "";
&popup_header(undef, $prehead);

# Links appear at the top of the page
my @links = grep { $_->{'type'} eq 'link' } @info;
@info = grep { $_->{'type'} ne 'link' } @info;
unshift(@links, { 'link' => 'edit_right.cgi',
	          'desc' => $text{'right_edit'} });
my @linkshtml = map {
	my $lnk = $_->{'link'};
	$lnk = &get_webprefix().$lnk
		if (&get_webprefix() && $lnk =~ /^\//);
	&ui_link($lnk, $_->{'desc'}, undef,
		 !$_->{'target'} ? '' :
	         $_->{'target'} eq 'new' ? 'target=_blank' :
		 $_->{'target'} eq 'window' ? 'target=_top' : '') } @links;
print "<div class=\"right-top-links\" align=right>\n";
print &ui_links_row(\@linkshtml);
print "</div>\n";
print &ui_switch_theme_javascript();
if (foreign_available("server-manager")) {
	print '<div class="main-logo cloudmin"><img width="275" alt="Cloudmin" src="data:image/svg+xml;base64,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"></div>';
	}
elsif (foreign_available("virtual-server")) {
	print '<div class="main-logo virtualmin"><img width="275" alt="Virtualmin" src="data:image/svg+xml;base64,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"></div>';
	}
else {
	if (get_product_name() eq 'webmin') {
		print '<div class="main-logo webmin"><img width="230" alt="Webmin" src="data:image/svg+xml;base64,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"></div>';
		}
	elsif (get_product_name() eq 'usermin') {
		print '<div class="main-logo usermin"><img width="230" alt="Usermin" src="data:image/svg+xml;base64,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"></div>';
		}
	}
# Show notifications first
@info = sort { ($b->{'type'} eq 'warning') <=> ($a->{'type'} eq 'warning') }
	     @info;

foreach my $info (@info) {
	if ($info->{'type'} eq 'warning') {
		my $w;
		if (ref($info->{'warning'}) eq 'HASH') {
			$w = $info->{'warning'}->{'alert'};
			}
		else {
			$w = &ui_alert_box($info->{'warning'},
					      $info->{'level'} || 'warn');
			}
		if ($info->{'desc'}) {
			print &ui_table_start($info->{'desc'}, "width=100%");
			print &ui_table_row(undef, $w, 4);
			print &ui_table_end();
			}
		else {
			print $w;
			}
		}
	else {
                my $open = defined($info->{'open'}) ? $info->{'open'} : 1;
                print &ui_hidden_table_start($info->{'desc'}, "width=100%", 4,
                                             $info->{'module'}.$info->{'id'},
                                             $open);
		if ($info->{'type'} eq 'table') {
			# A table of various labels and values
			if ($info->{'header'}) {
				print &ui_table_row(
					undef, $info->{'header'}, 4);
				}
			foreach my $t (@{$info->{'table'}}) {
				my $chart = "";
				if ($t->{'chart'}) {
					$chart = &make_bar_chart(
							$t->{'chart'});
					$chart = "<br>".$chart;
					}
				print &ui_table_row($t->{'desc'},
				    $t->{'value'}.$chart,
				    $t->{'wide'} || $t->{'chart'} ? 3 : 1);
				}
			}
		elsif ($info->{'type'} eq 'chart') {
			# A table of graphs
			my $ctable;
			if ($info->{'header'}) {
				$ctable .= $info->{'header'}."<br>\n";
				}
			$ctable .= &ui_columns_start($info->{'titles'});
			foreach my $t (@{$info->{'chart'}}) {
				$ctable .= &ui_columns_row([
					$t->{'desc'},
					&make_bar_chart($t->{'chart'}),
					$t->{'value'},
					]);
				}
			$ctable .= &ui_columns_end();
			print &ui_table_row(undef, $ctable, 4);
			}
		elsif ($info->{'type'} eq 'html') {
			# A chunk of HTML
			print &ui_table_row(undef, $info->{'html'}, 4);
			}
                print &ui_hidden_table_end();
		}
	}

print "</center>\n";
&popup_footer();

# bar_chart_three(total, used1, used2, used3)
# Returns HTML for a bar chart of three values, stacked
sub bar_chart_three
{
my ($total, $used1, $used2, $used3) = @_;
$used1 ||= 0;
$used2 ||= 0;
$used3 ||= 0;
my $rv;
my $w1 = int($bar_width*$used1/$total)+1;
my $w2 = int($bar_width*$used2/$total);
my $w3 = int($bar_width*$used3/$total);
$rv .= sprintf "<img src=images/red.gif width=%s height=10>", $w1;
$rv .= sprintf "<img src=images/purple.gif width=%s height=10>", $w2;
$rv .= sprintf "<img src=images/blue.gif width=%s height=10>", $w3;
$rv .= sprintf "<img src=images/grey.gif width=%s height=10>",
	$bar_width - $w1 - $w2 - $w3;
return $rv;
}

sub make_bar_chart
{
my ($c) = @_;
my @c = @$c;
$c[1] ||= 0;
$c[2] ||= 0;
if (@c == 2) {
	return &bar_chart_three(
		$c[0], $c[1], 0, $c[0]-$c[1]);
	}
else {
	return &bar_chart_three(
		$c[0], $c[1], $c[2],
		$c[0]-$c[1]-$c[2]);
	}
}

